currentItemId = -1

CrowbarUse = "fp_crowbar_use"
CrowbarUse2 = "fp_crowbar_use02"
SmallhammerUse = "fp_smallhammer_use"
ImpactdriverUse = "fp_impactdriver_use"

ConnecttoolEquip = "fp_connecttool_pickup"
ConnecttoolUnequip = "fp_connecttool_putaway"
ConnecttoolIdle = "fp_connecttool_idle"
ConnecttoolUseIdle = "fp_connecttool_useidle"

SledgehammerEquip = "fp_sledgehammer_pickup"
SledgehammerUnequip = "fp_sledgehammer_putaway"
SledgehammerIdle = "fp_sledgehammer_idle"
SledgehammerUse = "fp_sledgehammer_use"

HandbookEquip = "fp_handbook_pickup"
HandbookUnequip = "fp_handbook_putaway"
HandbookIdle = "fp_handbook_idle"
HandbookUse = "fp_handbook_use"
HandbookUseIdle = "fp_handbook_useidle"


anim = {}

anim[CrowbarUse] = {}
anim[CrowbarUse].loop = false
anim[CrowbarUse].tool = false
anim[CrowbarUse].entities = { "fp_crowbar", "fp_hands", "fp_arms" }

anim[CrowbarUse2] = {}
anim[CrowbarUse2].loop = false
anim[CrowbarUse2].tool = false
anim[CrowbarUse2].entities = { "fp_crowbar", "fp_hands", "fp_arms" }

anim[SmallhammerUse] = {}
anim[SmallhammerUse].loop = false
anim[SmallhammerUse].tool = false
anim[SmallhammerUse].entities = { "fp_smallhammer", "fp_hands", "fp_arms" }

anim[ImpactdriverUse] = {}
anim[ImpactdriverUse].loop = false
anim[ImpactdriverUse].tool = false
anim[ImpactdriverUse].entities = { "fp_impactdriver", "fp_hands", "fp_arms" }



anim[ConnecttoolEquip] = {}
anim[ConnecttoolEquip].loop = false
anim[ConnecttoolEquip].tool = true
anim[ConnecttoolEquip].entities = { "fp_connecttool", "fp_hands", "fp_arms" }

anim[ConnecttoolUnequip] = {}
anim[ConnecttoolUnequip].loop = false
anim[ConnecttoolUnequip].tool = true
anim[ConnecttoolUnequip].entities = { "fp_connecttool", "fp_hands", "fp_arms" }

anim[ConnecttoolIdle] = {}
anim[ConnecttoolIdle].loop = true
anim[ConnecttoolIdle].tool = true
anim[ConnecttoolIdle].entities = { "fp_connecttool", "fp_hands", "fp_arms" }

anim[ConnecttoolUseIdle] = {}
anim[ConnecttoolUseIdle].loop = true
anim[ConnecttoolUseIdle].tool = true
anim[ConnecttoolUseIdle].entities = { "fp_connecttool", "fp_hands", "fp_arms" }



anim[SledgehammerEquip] = {}
anim[SledgehammerEquip].loop = false
anim[SledgehammerEquip].tool = true
anim[SledgehammerEquip].entities = { "fp_sledgehammer", "fp_hands", "fp_arms" }

anim[SledgehammerUnequip] = {}
anim[SledgehammerUnequip].loop = false
anim[SledgehammerUnequip].tool = true
anim[SledgehammerUnequip].entities = { "fp_sledgehammer", "fp_hands", "fp_arms" }

anim[SledgehammerIdle] = {}
anim[SledgehammerIdle].loop = true
anim[SledgehammerIdle].tool = true
anim[SledgehammerIdle].entities = { "fp_sledgehammer", "fp_hands", "fp_arms" }

anim[SledgehammerUse] = {}
anim[SledgehammerUse].loop = false
anim[SledgehammerUse].tool = true
anim[SledgehammerUse].entities = { "fp_sledgehammer", "fp_hands", "fp_arms" }


anim[HandbookEquip] = {}
anim[HandbookEquip].loop = false
anim[HandbookEquip].tool = true
anim[HandbookEquip].entities = { "fp_handbook", "fp_hands", "fp_arms" }

anim[HandbookUnequip] = {}
anim[HandbookUnequip].loop = false
anim[HandbookUnequip].tool = true
anim[HandbookUnequip].entities = { "fp_handbook", "fp_hands", "fp_arms" }

anim[HandbookIdle] = {}
anim[HandbookIdle].loop = true
anim[HandbookIdle].tool = true
anim[HandbookIdle].entities = { "fp_handbook", "fp_hands", "fp_arms" }

anim[HandbookUse] = {}
anim[HandbookUse].loop = false
anim[HandbookUse].tool = true
anim[HandbookUse].entities = { "fp_handbook", "fp_hands", "fp_arms" }

anim[HandbookUseIdle] = {}
anim[HandbookUseIdle].loop = true
anim[HandbookUseIdle].tool = true
anim[HandbookUseIdle].entities = { "fp_handbook", "fp_hands", "fp_arms" }

animStack = {}

tool = {} 

tool[20000] = {}
tool[20000].equip = ConnecttoolEquip
tool[20000].unequip = ConnecttoolUnequip
tool[20000].idle = ConnecttoolIdle

tool[20001] = {}
tool[20001].equip = SledgehammerEquip
tool[20001].unequip = SledgehammerUnequip
tool[20001].idle = SledgehammerIdle

tool[20005] = {}
tool[20005].equip = HandbookEquip
tool[20005].unequip = HandbookUnequip
tool[20005].idle = HandbookIdle

currentCrowbarUse = CrowbarUse
blending = {}

function create_entities()
	CreateEntity("fp_arms", "char_hp_arms01.mesh", "char_male_chest01")
	CreateEntity("fp_hands", "char_hp_hands01.mesh", "char_male_hands01")
	CreateEntity("fp_connecttool", "tool_hp_connecttool.mesh", "tool_connecttool")
	CreateEntity("fp_sledgehammer", "tool_hp_sledgehammer.mesh", "tool_sledgehammer")
	CreateEntity("fp_handbook", "tool_hp_handbook.mesh", "tool_handbook")
	CreateEntity("fp_impactdriver", "tool_hp_impactdriver.mesh", "tool_impact_driver")
	CreateEntity("fp_smallhammer", "tool_hp_smallhammer.mesh", "tool_smallhammer")
	CreateEntity("fp_crowbar", "tool_hp_crowbar.mesh", "tool_crowbar")
end

function update_visibility()
	SetEntityVisible("fp_arms", false)
	SetEntityVisible("fp_hands", false)
	SetEntityVisible("fp_connecttool", false)
	SetEntityVisible("fp_sledgehammer", false)
	SetEntityVisible("fp_handbook", false)
	SetEntityVisible("fp_impactdriver", false)
	SetEntityVisible("fp_smallhammer", false)
	SetEntityVisible("fp_crowbar", false)
	
	local animation = animation_stack_peek()
	if animation ~= nil then
		local a = anim[animation]
		for i, ent in ipairs(a.entities) do
			SetEntityVisible(ent, true)
		end
	end
end

function set_current_item_id(itemId)
	if currentItemId ~= itemId then
		local t0 = tool[currentItemId]
		local t1 = tool[itemId]
		
		if t0 ~= nil then
			animation_stack_remove(t0.equip)
			animation_stack_remove(t0.idle)
		end
			
		if t1 ~= nil then
			animation_stack_remove_tools()
			animation_stack_push(t1.equip, true)
			animation_stack_push(t1.idle, true)
			animation_stack_push(t1.unequip, true)
		end
	
		currentItemId = itemId
	end
end

function handle_event(event)
	if event == "place_shape" then
		animation_stack_push(SmallhammerUse)
		animation_stack_remove_tools()
		
	elseif event == "create_shape_on_bearing" then
		animation_stack_push(ImpactdriverUse)
		animation_stack_remove_tools()
		
	elseif event == "begin_destroy_shape" then
		animation_stack_remove_tools()
		animation_stack_push(currentCrowbarUse, true, true, true)
		Console(currentCrowbarUse)
		
	elseif event == "cancel_destroy_shape" then
		animation_stack_remove(currentCrowbarUse)
		
	elseif event == "finish_destroy_shape" then
		if currentCrowbarUse == CrowbarUse then
			currentCrowbarUse = CrowbarUse2
		else
			currentCrowbarUse = CrowbarUse
		end
	
	elseif event == "begin_destroy_shape_marker" then
		animation_stack_remove_tools()
		animation_stack_push(SledgehammerUse)
		
	elseif event == "cancel_destroy_shape_marker" then
		animation_stack_remove(SledgehammerUse)
		
	elseif event == "finish_destroy_shape_marker" then
		
		
	elseif event == "sledgehammer_hit" then
		animation_stack_push(SledgehammerUse, false, true, true)
		
	
	elseif event == "connecttool_connect_start" then
		animation_stack_push(ConnecttoolUseIdle, false, true)
		
	elseif event == "connecttool_connect_end" then
		animation_stack_remove(ConnecttoolUseIdle, true)
	
	elseif event == "handbook_open" then
		animation_stack_push(HandbookUseIdle, false, true)
		--animation_stack_push(HandbookUse)
		
	elseif event == "handbook_close" then
		animation_stack_remove(HandbookUseIdle, true)
	
	end
	
	--Console(event)
end

function animation_ended(animation)
	animation_stack_remove(animation)
end

function animation_stack_push(animation, bottom, blendIn, blendOut)
	bottom = bottom or false
	blendIn = blendIn or false
	blendOut = blendOut or false
	
	if bottom then
		table.insert(animStack, 1, animation)
		if #animStack == 1 then
			start_animation(animation)
		end
	else
		local currentAnimation = animation_stack_peek()
		if animation ~= currentAnimation then
			if currentAnimation ~= nil and not (blendIn or blendOut) then
				stop_animation(currentAnimation)
			end
			table.insert(animStack, animation)
		end
		start_animation(animation, blendIn, blendOut)
	end
end

function animation_stack_pop()
	local animation = animation_stack_peek()
	if animation ~= nil then
		stop_animation(animation)
		table.remove(animStack)
		
		local nextAnimation = animation_stack_peek()
		if nextAnimation ~= nil then
			start_animation(nextAnimation)
		end
	end
end

function animation_stack_peek()
	if #(animStack) > 0 then
		return animStack[#animStack]
	end
	return nil
end

function animation_stack_remove(animation, blend)
	blend = blend or false
	for i, a in ipairs(animStack) do
		if animation == a then
			if blend then
				BlendOutAnimation(animation)
				Console("blend out: "..animation)
			else
				if i == #animStack then
					animation_stack_pop()
				else
					table.remove(animStack, i)
				end
			end
			return
		end
	end
end

function animation_stack_remove_tools()
	for i = #animStack, 1, -1 do
		if anim[animStack[i]].tool then
			if i == #animStack then
				animation_stack_pop()
			else
				table.remove(animStack, i)
			end
		end
	end
end

function start_animation(animation, blendIn, blendOut)
	blendIn = blendIn or false
	blendOut = blendOut or false
	local a = anim[animation]
	for i, ent in ipairs(a.entities) do
		SetEntityVisible(ent, true)
		SetAnimationEnabled(ent, animation, true, a.loop)
		ResetAnimation(ent, animation, blendIn, blendOut)
	end
end

function stop_animation(animation)
	local a = anim[animation]
	for i, ent in ipairs(a.entities) do
		SetAnimationEnabled(ent, animation, false)
		SetEntityVisible(ent, false)
	end
end
